#---------------------------------------------------------------
#
# OCCPROTXScriptTemplate.pl	- code part of OCC script
#
# Copyright (c) Actinic Software Ltd 2001 All rights reserved
#
# *** Do not change this code unless you know what you are doing ***
#
# Written by George Menyhert
#
# Adapted for PROTX VPS Version 2.2 by Mat Peck - 27/05/2002
# Includes simple XOR encryption and Base64 encode functions
#
# Adapted for PROTX VPS Version 3.00 by Dean Winsbury - 22/01/2015
# Includes AES encryption and additional required fields
# Prerequisites	: 	Installed Perl modules
#				perl::Crypt::CBC
#				perl::Crypt::OpenSSL::AES
#				perl::Crypt::Rijndael
#
# This script is called by an eval() function and it will already
# have the following variables set up:
#
#	Expects:		$::sOrderNumber		- the alphanumeric order number for this order
#				$::nOrderTotal		- the total for this order (stored in based currency format e.g. 1000 = $10.00)
#				%::PriceFormatBlob   	- the price format data
#				%::InvoiceContact	- the customer invoice contact information
#				%::OCCShipData		- the customer delivery contact information
#				$::sCallBackURLAuth	- the URL of the authorization callback script
#				$::sCallBackURLBack	- the URL of the backup script
#				$::sCallBackURLUser	- the URL of the receipt script
#				$::sPath					- the path to the Catalog directory
#				$::sWebSiteUrl			- the Catalog web site URL
#				$::sContentUrl			- the content URL
#
#	Affects:		$::eStatus     		- the status of the transaction:
#				$::FAILURE 	- Failure
#				$::ACCEPTED - Accepted
#				$::REJECTED - Rejected
#				$::PENDING  - Pending
#				$::sErrorMessage		- error message if any
#				$::sHTML					- the HTML to display
#
#  $Revision: 25914 $
#
#---------------------------------------------------------------

use strict;
use Crypt::CBC;							# perl AES encryption module to use perl::Crypt::OpenSSL::AES cipher
use Crypt::Rijndael;						# perl Rijndael encryption module to decode Sagepay response crypt field

$::eStatus = $::PENDING;					# The OCC plug-in runs in pending mode.  This script does not
								# perform the transaction.  Rather, it forwards the customer to
								# the OCC site for completion.
my (%VarTable);

######################################################################
# PROTX VPS Specific constants here
######################################################################

my $sMerchantID = $sADF01;
my $sPassword = $sADF03;
my $sConfirmationEMail = $sADF04;

######################################################################

my $sSagePayURL = '';
 
    if ($bTestMode) {
    #  $sSagePayURL = "http://localhost/";
    #  $sSagePayURL = "https://test.sagepay.com/";
       $sSagePayURL = "https://test.sagepay.com/gateway/service/";		#new v3.00 address
    } else {
    #  $sSagePayURL = "http://localhost/";
    #  $sSagePayURL = "https://live.sagepay.com/";
       $sSagePayURL = "https://live.sagepay.com/gateway/service/";		#new v3.00 address
}

######################################################################


## Shared Script, different HTML templates;

$VarTable{$::VARPREFIX . 'OCC_URL'} =				# insert the OCC web site URL into the HTML template
	$sProcessScriptURL;

#
# only the Vendor name, Protocol ID and Transaction type are plain text for VPS
# all other values are passed in the encrypted CRYPT field
# First add the plain text values
#

my $sHiddenValues;
my $sCrypt;

$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"VPSProtocol\" VALUE=\"3.00\">\n";				# upgraded to v3.00
if ($bAuthenticate)
	{
	$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"TxType\" VALUE=\"AUTHENTICATE\">\n";
	}
elsif (!$bAuthorize)											# if in pre-authorize mode, change the TxType to DEFERRED
	{
	$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"TxType\" VALUE=\"DEFERRED\">\n";
	}
else
	{
	$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"TxType\" VALUE=\"PAYMENT\">\n";
	}
$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"Vendor\" VALUE=\"$sMerchantID\">\n";

#
# build up a string of all other values to encrypt and place in the crypt field
#

#
# VendorTxCode needs a random element to ensure this code has not been used before
#
$sCrypt .= "VendorTxCode=". $::sOrderNumber . "-" . int(rand(100000)) . "&";

#
# VPS requires decimal places in the amount (not lowest digits, so work them out).
#

my $nNumDigits = $::PriceFormatBlob{"ICURRDIGITS"};	# read the currency format values
my ($nAmount, $nFactor, $sAmount);
if(defined $nNumDigits)	{$nFactor = (10 ** $nNumDigits);} else {$nFactor = 100;}
$sAmount = sprintf("%d.%02d", $::nOrderTotal / $nFactor, $::nOrderTotal % $nFactor);

$sCrypt .= "Amount=". $sAmount . "&";
$sCrypt .= "Currency=". $::PriceFormatBlob{SINTLSYMBOLS} . "&";
$sCrypt .= "Description=Costumechest Order&";

#
# URLs:
#		Strip them out and URL encode them for inclusion in the completion URL.
#		AUTH - the URL to create the authorization blob
#		BACK - the URL to return to the Catalog checkout process
#		USER - the URL to the receipt script
#
#$sCrypt .= "SuccessURL=".$sSagePayURL."vps2Form/ActSuccess.asp?ActVendor=" .$sMerchantID. "&ActAmount=" . $::nOrderTotal . "&AuthURL=" . Base64Encode($::sCallBackURLAuth);
#$sCrypt .= "&InvoiceURL=" . Base64Encode($::sCallBackURLUser) . "&";
#$sCrypt .= "FailureURL=".$sSagePayURL."vps2Form/ActFail.asp?ActVendor=" .$sMerchantID. "&RedirectURL=" . Base64Encode($::sCallBackURLBack) . "&";


#
# URLs for v3.0
#

$sCrypt .= "SuccessURL=" . $::sCallBackURLAuth . "&";
$sCrypt .= "InvoiceURL=" . $::sCallBackURLUser . "&";		# Not used ???
$sCrypt .= "FailureURL=" . $::sCallBackURLBack . "&";

#
# add the invoice address and customer name
#
my ($sFirstName, $sLastName);
$sLastName = $::InvoiceContact{NAME};				# default to a blank first name and complete last name
if ($sLastName =~ /^(.+)\s+(\S+)/)					# if the name field looks to contain at least two name parts
	{
	$sFirstName = $1;										# break the name up
	$sLastName = $2;
	}
	
my ($sCountry, $sState) = GetProtxLocationCodes('INVOICE');
	
$sCrypt .= "BillingSurname=" . $sLastName . "&";
$sCrypt .= "BillingFirstnames=" . $sFirstName . "&";
$sCrypt .= "BillingAddress1=" . $::InvoiceContact{ADDRESS1} . "&";
$sCrypt .= "BillingAddress2=" .  $::InvoiceContact{ADDRESS2} . "&"; 
$sCrypt .= "BillingCity=" . $::InvoiceContact{ADDRESS3} . "&"; 
$sCrypt .= "BillingState=" . $sState . "&"; 
$sCrypt .= "BillingCountry=" . $sCountry . "&"; 
$sCrypt .= "BillingPostCode=" . substr($::InvoiceContact{POSTALCODE}, 0, 10);
if (length($::InvoiceContact{PHONE})!=0)  { $sCrypt .= "&BillingPhone=" . $::InvoiceContact{PHONE}; }


#
# add the delivery address 
#
$sLastName = $::OCCShipData{NAME};				# default to a blank first name and complete last name
if ($sLastName =~ /^(.+)\s+(\S+)/)					# if the name field looks to contain at least two name parts
	{
	$sFirstName = $1;										# break the name up
	$sLastName = $2;
	}
	
($sCountry, $sState) = GetProtxLocationCodes('DELIVERY');
	
$sCrypt .= "&DeliverySurname=" . $sLastName . "&";
$sCrypt .= "DeliveryFirstnames=" . $sFirstName . "&";
$sCrypt .= "DeliveryAddress1=" .$::OCCShipData{ADDRESS1} . "&";
$sCrypt .= "DeliveryAddress2=" . $::OCCShipData{ADDRESS2} . "&"; 
$sCrypt .= "DeliveryCity=" . $::OCCShipData{ADDRESS3} . "&"; 
$sCrypt .= "DeliveryState=" . $sState . "&"; 
$sCrypt .= "DeliveryCountry=" . $sCountry . "&"; 
if (length($::OCCShipData{PHONE}) != 0) {$sCrypt .= "DeliveryPhone=" . $::OCCShipData{PHONE} . "&"; }  
$sCrypt .= "DeliveryPostCode=" . substr($::OCCShipData{POSTALCODE}, 0, 10); 

#
# Add confirmation email addresses if present.
#

if (length($::InvoiceContact{EMAIL})!=0)  { $sCrypt .= "&CustomerEMail=" . $::InvoiceContact{EMAIL}; }
if (length($sConfirmationEMail)!=0)  { $sCrypt .= "&VendorEMail=" . $sConfirmationEMail; }

# Add new 2.22 fields as well

$sCrypt .= "&eMailMessage= ";				# add text to this field to include in confirmation emails
$sCrypt .= "&AllowGiftAid=0";
$sCrypt .= "&ApplyAVSCV2=0";
$sCrypt .= "&Apply3DSecure=0";

# Add new 3.00 fields as well

# 	$sCrypt .= "&BasketXML=";		# Optional - not used in Actinic v.10
# 	$sCrypt .= "&CustomerXML=";		# Optional - not used in Actinic v.10
# 	$sCrypt .= "&SurchargeXML=";		# Optional - not used in Actinic v.10
# 	$sCrypt .= "&VendorData=";		# Optional - not used in Actinic v.10
# 	$sCrypt .= "&ReferrerID=";		# Optional - not used in Actinic v.10
# 	$sCrypt .= "&Language=en";		# Optional - ISO 639 checkout language, default is shoppers browser language
#	$sCrypt .= "&Website=www.myURL.tld";	# Optional - adds website URL to Sage Pay record
# 	$sCrypt .= "&BillingAgreement=0";	# Mandatory for PAYPAL REFERENCE transactions. [0 or 1]

#
# add the crypt field to the POST 
#

#$sCrypt = Base64Encode(SimpleXOR($sCrypt,$sPassword));
$sCrypt = AESEncrypt($sPassword,$sCrypt);				# use new AES encryption method

$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"Crypt\" VALUE=\"$sCrypt\">\n";


#
# Original OCC Script routines continue...
#


$VarTable{$::VARPREFIX . 'OCC_VALUES'} =			# add the OCC values to the template
	$sHiddenValues;

my $sLinkHTML = 'occlink.html';
if(defined $::g_pPaymentList)
	{
	$sLinkHTML = $$::g_pPaymentList{ActinicOrder::PaymentStringToEnum($::g_PaymentInfo{'METHOD'})}{BOUNCE_HTML};
	}
@Response = ACTINIC::TemplateFile($::sPath . $sLinkHTML, \%VarTable); # build the file

if ($Response[0] != $::SUCCESS)
	{
	$::eStatus = $::FAILURE;							# return a plug-in error
	$::sErrorMessage = $Response[1];
	return ($::SUCCESS);									# always return success if the script runs
	}

@Response = ACTINIC::MakeLinksAbsolute($Response[2], $::sWebSiteUrl, $::sContentUrl);
if ($Response[0] != $::SUCCESS)
	{
	$::eStatus = $::FAILURE;							# return a plug-in error
	$::sErrorMessage = $Response[1];
	return ($::SUCCESS);									# always return success if the script runs
	}

$::sHTML = $Response[2];								# grab the resulting HTML
#
# process the test mode warning
#
my ($sDelimiter) = $::DELPREFIX . 'TESTMODE';
if ($bTestMode)											# only include the test mode block if we are in test mode
	{
	$::sHTML =~ s/$sDelimiter//g;						# remove the delimiter text
	}
else															# not in test mode - remove the block
	{
	$::sHTML =~ s/$sDelimiter(.*?)$sDelimiter//gs;	# remove the test mode warning blob (/s removes the \n limitation of .)
	}

return ($::SUCCESS);

#
# End of Original OCCPROTXScriptTemplate.pl
#

################################################################
#
# GetProtxLocationCodes - Get the appropriate country and region codes
#
#	The merchant's	country code is used if a country hasn't been specified
#	This is to handle the case where the merchant only ships to their own
#	country and they use simple tax and shipping.
#
#	UK is translated to the ISO code GB
#
#	If UK has states specified, the region code is blanked.
#
# Input:	$sAddress	- 'INVOICE' or 'DELIVERY'
#
# Returns: 	($sCountryCode, $sStateCode)
#
################################################################

sub GetProtxLocationCodes
	{
	my ($sAddress) = @_;
	#
	# Handle country code first
	#
	my $sCountryCode = $::g_LocationInfo{$sAddress . '_COUNTRY_CODE'};
	if ($sCountryCode eq '')
		{
		$sCountryCode = $::g_pSetupBlob->{'MERCHANT_COUNTRY_CODE'};
		}
	#
	# Handle state code according to country
	#
	my $sStateCode = '';
	if ($sCountryCode eq 'UK')
		{
		$sCountryCode =~ s/^UK$/GB/;
		}
	elsif ($sCountryCode eq 'US')
		{
		my $sRegionKey = $sAddress . '_REGION_CODE';
		$sStateCode = $::g_LocationInfo{$sRegionKey};
		$sStateCode = ($sStateCode ne $ActinicOrder::UNDEFINED_REGION) ? 	
			ActinicLocations::GetISORegionCode($sStateCode) : "";
		}
	return ($sCountryCode, $sStateCode);
	}
# 
# Base64 encoding
# 
sub Base64Encode ($;$)
{
    my $res = "";
    my $eol = $_[1];
    $eol = "\n" unless defined $eol;
    pos($_[0]) = 0;                          # ensure start at the beginning

    $res = join '', map( pack('u',$_)=~ /^.(\S*)/, ($_[0]=~/(.{1,45})/gs));

    $res =~ tr|` -_|AA-Za-z0-9+/|;               # `# help emacs
    # fix padding at the end
    my $padding = (3 - length($_[0]) % 3) % 3;
    $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
    return $res;
}


# 
# Base64 decoding
# 
sub Base64Decode ($)
{
    local($^W) = 0; 

    my $str = shift;
    $str =~ tr|A-Za-z0-9+=/||cd;            # remove non-base64 chars
    if (length($str) % 4) {
	require Carp;
	Carp::carp("Length of base64 data not a multiple of 4")
    }
    $str =~ s/=+$//;                        # remove padding
    $str =~ tr|A-Za-z0-9+/| -_|;            # convert to uuencoded format

    return join'', map( unpack("u", chr(32 + length($_)*3/4) . $_),
	                $str =~ /(.{1,60})/gs);
}


# 
# SimpleXor password encryption
# 
sub SimpleXOR ($;$)
{
  my $plain = $_[0];
  my $password = $_[1];
  my $passstring = $_[1];
  my $res = "";

  while (length($passstring) <= length($plain)) { $passstring .= $password; }
  $passstring = substr($passstring,0,length($plain));

  $res = $plain ^ $passstring;

  return $res;

}

# ================================================================================
#
# 			Subroutine AESEncrypt 
#			---------------------
# 
# Encrypts Sagepay AES v3.0 crypt field
# to use: AESEncrypt("key","cleartext")
#
# ================================================================================


        sub AESEncrypt{
                $_[2] = Crypt::CBC->new(-key            => $_[0],
                                        -iv             => $_[0],
                                        -cipher         => 'Crypt::OpenSSL::AES',
                                        -header         => 'none',
                                        -literal_key    => 1,
                                        -keysize        => 128 / 8,
                                        -padding        => 'standard'
                                        )->encrypt($_[1]);                      # encrypt
                $_[2] = unpack( 'H*', $_[2] );                                  # convert to Hex
                $_[2] = '@' . uc($_[2]) ;                                       # prepend @ and convert to uppercase
        }




# ================================================================================
#
# 			Subroutine AESDecrypt 
#			---------------------
# 
# decrypts a Sagepay AES v3.0 outgoing crypt field
# to use: AESDecrypt("key","aes crypted hex")
#
# ================================================================================


        sub AESDecrypt{
                $_[1] = substr $_[1] , 1 ;                                       #remove leading @
                $_[1] = pack( 'H*', $_[1] );                                     #convert from Hex
                $_[2] = Crypt::CBC->new(-key            => $_[0],
                                        -iv             => $_[0],
                                        -cipher         => 'Crypt::OpenSSL::AES',
                                        -header         => 'none',
                                        -literal_key    => 1,
                                        -keysize        => 128 / 8,
                                        -padding        => 'standard'
                                        )->decrypt($_[1]);                       #decrypt
        }




# ================================================================================
#
#                       Subroutine RDecrypt
#                       -------------------
#
# decrypts a returned Sagepay AES 3.0 crypt field
# to use: RDecrypt("key","rijndael crypted hex")
#
# Sagepay encodes V3.00 responses with Rijndael encryption which is not compatible 
# with OpenSSL:AES http://search.cpan.org/~bdfoy/Crypt-Rijndael-1.12/Rijndael.pm
# 
#
# ================================================================================

        sub RDecrypt{
                $_[1] = substr $_[1] , 1 ;                                       #remove leading @
                $_[1] = pack( 'H*', $_[1] );                                     #convert from Hex

                my $cipher =Crypt::Rijndael->new($_[0],Crypt::Rijndael::MODE_CBC() );
                $cipher->set_iv($_[0]);

                $_[2] = $cipher->decrypt($_[1]);                                #decrypt
        }




# ================================================================================
#
#                       Subroutine Clean
#                       -----------------
# removes \n and \r characters from string
# required to clean decoded string after RDecrypt()
#
# ================================================================================


	sub Clean {

		my $text;
      		  	$text = $_[0];
     		   	$text =~ s/\n//g;         		              # strip LF
     		   	$text =~ s/\r//g;          		             # strip CR
		return $text;
	}
